/*
 * Decompiled with CFR 0.152.
 */
package gsis.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;

public class PrintableEditorPane
extends JEditorPane
implements Printable,
Serializable {
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension d = this.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.paint(g2);
        return 0;
    }

    public void doPrintActions() {
        boolean UserPressedOK = true;
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        UserPressedOK = pj.printDialog();
        if (UserPressedOK) {
            try {
                pj.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

